; created by KornilovAF
; at 2012/10/14 - 12:33:21
;---------------------------------------
; AVR_TYPE=<Attyne2313>
;---------------------------------------
;---------------------------------------
; constants:

.include	"tn2313def.inc"

.def	tmp = r16
.def	InPort = r17
.def	OutPort = r18
.def	tmp2 = r23

.equ	j	= 10	;

;---------------------------------------------
;    
;---------------------------------------------
;---------------------------------------

.org	0x0000
	rjmp	start

	nop		;    INT0addr        = 0x001     ;External Interrupt0
	nop		;    INT1addr        = 0x002     ;External Interrupt1
	nop		;    ICP1addr        = 0x003     ;Input capture interrupt 1
	nop		;    OC1Aaddr        = 0x004     ;Timer/Counter1 Compare Match A     
	nop		;    OVF1addr        = 0x005     ;Overflow1 Interrupt 
	nop		;    OVF0addr        = 0x006     ;Overflow0 Interrupt
	nop		;    URXC0addr       = 0x007     ;USART0 RX Complete Interrupt
	nop		;    UDRE0addr       = 0x008     ;USART0 Data Register Empty Interrupt
	nop		;    UTXC0addr       = 0x009     ;USART0 TX Complete Interrupt 
	nop		;    ACIaddr         = 0x00A     ;Analog Comparator Interrupt 
	nop		;    PCINTaddr       = 0x00B     ;Pin Change Interrupt
	nop		;    OC1Baddr        = 0x00C     ;Timer/Counter1 Compare Match B
	nop		;    OC0Aaddr        = 0x00D     ;Timer/Counter0 Compare Match A     
	nop		;    OC0Baddr        = 0x00E     ;Timer/Counter0 Compare Match B     
	nop		;    USI_STARTaddr   = 0x00F     ;USI start interrupt
	nop		;    USI_OVFaddr     = 0x010     ;USI overflow interrupt
	nop		;    ERDYaddr        = 0x011     ;EEPROM write complete
	nop		;    WDTaddr         = 0x012     ;Watchdog Timer Interrupt
		; for compatibility purpose



;=======================================
;	 
;=======================================
Delay:
	ldi	r19,j
Loop2:
	ldi	r20,0x2A
Loop1:
	dec	r20
	brne	Loop1
	dec	r19
	brne	Loop2

	brtc	L0
	sbis	PORTA,0
	rjmp	L1
	cbi		PORTA,0
	rjmp	L0
L1:
	sbi		PORTA,0
L0:
	dec	r22
	brne	Delay
	ret

;=======================================
;	 
;=======================================
start:
	ldi	tmp,low(RAMEND)
	out SPL,tmp

	clr	tmp
	out	DDRD,tmp
	out	PORTB,tmp
	
	ser	tmp
	out	PORTD,tmp
	out	DDRB,tmp

	ldi	tmp,0b00000011
	out	DDRA,tmp
	com	tmp
	out	PORTA,tmp
	ser	tmp		

st1:
	brtc	L2
	dec		r24
	tst		r24
	brne	L2
	clt

L2:
	rcall	Delay
	in	InPort,PIND
	sbic	PINA,2
	sbr	InPort,0b10000000
	com	InPort
	mov	tmp2,InPort
	sub		tmp2,tmp
	breq	St1

	set
	ldi	r24,0x5
	mov	tmp,InPort
	eor	OutPort,InPort
	out	PORTB,OutPort
	rjmp	st1


